﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

using QCAP.NET;

namespace StreamCatcherDemo
{
    public partial class Form1 : Form
    {
        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);

        public Form1()
        {
            InitializeComponent();
        }

        public uint i = 0;

        public bool m_bIsMaximizedForm = false;

        public bool[] m_bIsMaximizedChannelWindow = new bool[8];

        public bool[] m_bNoSignal = new bool[8];

        public string[] m_strFormatChangedOutput = new string[8];

        public bool[] m_bShareRecordCH = new bool[8];

        public bool m_bShowClone = false;

        public bool m_bIsShareRecord = false;

        public uint m_nVideoWidth = 1920;

        public uint m_nVideoHeight = 1080;

        public double m_dVideoFrameRate = 60.0;

        public bool m_bIsStreaming = false;

        public uint m_hRtspCapDev = 0;                                    // RTSP STREAM CAPTURE DEVICE

        // CRITICAL SECTION OBJECT
        // 
        volatile public uint[] m_nNetworkServerState_v = new uint[8];

        public Object m_hNetworkServerAccessCriticalSection_v0 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_v1 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_v2 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_v3 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_v4 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_v5 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_v6 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_v7 = new Object();

        volatile public uint[] m_nNetworkServerState_a = new uint[8];

        public Object m_hNetworkServerAccessCriticalSection_a0 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_a1 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_a2 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_a3 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_a4 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_a5 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_a6 = new Object();

        public Object m_hNetworkServerAccessCriticalSection_a7 = new Object();

        // FOURCC MARCO
        //
        uint MAKEFOURCC(uint ch0, uint ch1, uint ch2, uint ch3)
        {
            return ((uint)(byte)(ch0) | ((uint)(byte)(ch1) << 8) | ((uint)(byte)(ch2) << 16) | ((uint)(byte)(ch3) << 24));
        }

        // CALLBACK FUNCTION
        //        
        EXPORTS.PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB;

        EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB;

        EXPORTS.PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB;

        EXPORTS.PF_VIDEO_PREVIEW_CALLBACK m_pPreviewVideoCB;

        EXPORTS.PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB;

        public MySetupControl m_cSetupControl = new MySetupControl();

        // UNCOMPRESSION BUFFER
        //
        public byte[] m_bytesFrameBuffer;

        public GCHandle m_pinnedFrameArray;

        public IntPtr m_pointerFrameAry;

        // LIVE PREVIEW CHANNEL WINDOW
        //
        public MyChannelControl[] m_pChannelControl_LIVE = new MyChannelControl[8];

        string m_strChipName = "TW6802 PCI";        

        // DEVICE PROPERTY
        //
        public uint[] m_hCapDev = new uint[8];                     // STREAM CAPTURE DEVICE

        public uint[] m_hCloneCapDev = new uint[8];                // CLONE STREAM CAPTURE DEVICE

        //  FORMAT CHANGED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_format_changed(uint pDevice, uint nVideoInput, uint nAudioInput, uint nVideoWidth, uint nVideoHeight, uint bVideoIsInterleaved, double dVideoFrameRate, uint nAudioChannels, uint nAudioBitsPerSample, uint nAudioSampleFrequency, uint pUserData)
        {
            uint nCH = pUserData;

            // OUTPUT FORMAT CHANGED MESSAGE
            //
            string strOutput = "CH" + (nCH + 1).ToString() + " -> FORMAT CHANGED : pDevice : " + pDevice.ToString() + " , " + "nVideoInput : " + nVideoInput.ToString() + " , " +

                                        "nAudioInput : " + nAudioInput.ToString() + " , " + "nVideoWidth : " + nVideoWidth.ToString() + " , " +

                                        "nVideoHeight : " + nVideoHeight.ToString() + " , " + "bVideoIsInterleaved : " + bVideoIsInterleaved.ToString() + " , " +

                                        "dVideoFrameRate : " + dVideoFrameRate.ToString() + " , " + "nAudioChannels : " + nAudioChannels.ToString() + " , " +

                                        "nAudioBitsPerSample : " + nAudioBitsPerSample.ToString() + " , " + "nAudioSampleFrequency : " + nAudioSampleFrequency.ToString() + " , " +

                                        "pUserData : " + pUserData.ToString() + " \n";

            OutputDebugString(strOutput);

            m_nVideoWidth = nVideoWidth;

            m_nVideoHeight = nVideoHeight;

            m_dVideoFrameRate = dVideoFrameRate;

            uint nVH = 0;

            string strFrameType = " P ";

            string strVideoInput = "", strAudioInput = "";

            if (nVideoInput == 0) { strVideoInput = "COMPOSITE"; } if (nVideoInput == 1) { strVideoInput = "SVIDEO"; } if (nVideoInput == 2) { strVideoInput = "HDMI"; }

            if (nVideoInput == 3) { strVideoInput = "DVI_D"; } if (nVideoInput == 4) { strVideoInput = "COMPONENTS (YCBCR)"; } if (nVideoInput == 5) { strVideoInput = "DVI_A (RGB / VGA)"; }

            if (nVideoInput == 6) { strVideoInput = "SDI"; } if (nVideoInput == 7) { strVideoInput = "AUTO"; }

            if (nAudioInput == 0) { strAudioInput = "EMBEDDED_AUDIO"; } if (nAudioInput == 1) { strAudioInput = "LINE_IN"; }

            if (bVideoIsInterleaved == 1) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

            if (bVideoIsInterleaved == 1) { strFrameType = " I "; } else { strFrameType = " P "; }

            m_strFormatChangedOutput[nCH] = @" INFO : " + nVideoWidth.ToString() + " x " + nVH.ToString() + strFrameType + " @" + dVideoFrameRate.ToString() +

                " FPS , " + nAudioChannels.ToString() + " CH x " + nAudioBitsPerSample.ToString() + " BITS x " + nAudioSampleFrequency.ToString() + " HZ , " +

                " VIDEO INPUT : " + strVideoInput + " , " + " AUDIO INPUT : " + strAudioInput + " \n";

            // NO SIGNAL
            //       
            if (nVideoWidth == 0 && nVideoHeight == 0 && dVideoFrameRate == 0.0 && nAudioChannels == 0 && nAudioBitsPerSample == 0 && nAudioSampleFrequency == 0)
            {
                m_bNoSignal[nCH] = true;
            }
            else
            {
                m_bNoSignal[nCH] = false;
            }

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // PREVIEW VIDEO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_video_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            uint nCH = pUserData;
           
            if (m_bIsShareRecord && m_bShareRecordCH[nCH])
            {                
                EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen);             
            }

            if (m_bIsStreaming && m_hRtspCapDev != 0)
            {                
                switch (nCH)
                {
                    case 0:
                        lock (m_hNetworkServerAccessCriticalSection_v0)
                        {
                            if (m_nNetworkServerState_v[nCH] > 0x00000000)
                            {
                                EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen);
                            }
                        }
                        break;
                    case 1:
                        lock (m_hNetworkServerAccessCriticalSection_v1)
                        {
                            if (m_nNetworkServerState_v[nCH] > 0x00000000)
                            {
                                EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen);
                            }
                        }
                        break;
                    case 2:
                        lock (m_hNetworkServerAccessCriticalSection_v2)
                        {
                            if (m_nNetworkServerState_v[nCH] > 0x00000000)
                            {
                                EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen);
                            }
                        }
                        break;
                    case 3:
                        if (nCH == 3)
                        {
                            lock (m_hNetworkServerAccessCriticalSection_v3)
                            {
                                if (m_nNetworkServerState_v[nCH] > 0x00000000)
                                {
                                    EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen);
                                }
                            }
                        }
                        break;
                    case 4:
                        if (nCH == 4)
                        {
                            lock (m_hNetworkServerAccessCriticalSection_v4)
                            {
                                if (m_nNetworkServerState_v[nCH] > 0x00000000)
                                {
                                    EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen);
                                }
                            }
                        }
                        break;
                    case 5:
                        if (nCH == 5)
                        {
                            lock (m_hNetworkServerAccessCriticalSection_v5)
                            {
                                if (m_nNetworkServerState_v[nCH] > 0x00000000)
                                {
                                    EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen);
                                }
                            }
                        }
                        break;
                    case 6:
                        if (nCH == 6)
                        {
                            lock (m_hNetworkServerAccessCriticalSection_v6)
                            {
                                if (m_nNetworkServerState_v[nCH] > 0x00000000)
                                {
                                    EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen);
                                }
                            }
                        }
                        break;
                    case 7:
                        if (nCH == 7)
                        {
                            lock (m_hNetworkServerAccessCriticalSection_v7)
                            {
                                if (m_nNetworkServerState_v[nCH] > 0x00000000)
                                {
                                    EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen);
                                }
                            }
                        }
                        break;
                    default:
                        break;
                }
            }

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // PREVIEW AUDIO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_audio_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            uint nCH = pUserData;            

            if (m_bIsShareRecord && m_bShareRecordCH[nCH])
            {
                EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, pFrameBuffer, nFrameBufferLen);
            }

            if (m_bIsStreaming && m_hRtspCapDev != 0)
            {
                //EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, pFrameBuffer, nFrameBufferLen);

                switch (nCH)
                {
                    case 0:
                        lock (m_hNetworkServerAccessCriticalSection_a0)
                        {
                            if (m_nNetworkServerState_a[nCH] > 0x00000000)
                            {
                                EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, pFrameBuffer, nFrameBufferLen);
                            }
                        }
                        break;
                    case 1:
                        lock (m_hNetworkServerAccessCriticalSection_a1)
                        {
                            if (m_nNetworkServerState_a[nCH] > 0x00000000)
                            {
                                EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, pFrameBuffer, nFrameBufferLen);
                            }
                        }
                        break;
                    case 2:
                        lock (m_hNetworkServerAccessCriticalSection_a2)
                        {
                            if (m_nNetworkServerState_a[nCH] > 0x00000000)
                            {
                                EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, pFrameBuffer, nFrameBufferLen);
                            }
                        }
                        break;
                    case 3:
                        if (nCH == 3)
                        {
                            lock (m_hNetworkServerAccessCriticalSection_a3)
                            {
                                if (m_nNetworkServerState_a[nCH] > 0x00000000)
                                {
                                    EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, pFrameBuffer, nFrameBufferLen);
                                }
                            }
                        }
                        break;
                    case 4:
                        if (nCH == 4)
                        {
                            lock (m_hNetworkServerAccessCriticalSection_a4)
                            {
                                if (m_nNetworkServerState_a[nCH] > 0x00000000)
                                {
                                    EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, pFrameBuffer, nFrameBufferLen);
                                }
                            }
                        }
                        break;
                    case 5:
                        if (nCH == 5)
                        {
                            lock (m_hNetworkServerAccessCriticalSection_a5)
                            {
                                if (m_nNetworkServerState_a[nCH] > 0x00000000)
                                {
                                    EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, pFrameBuffer, nFrameBufferLen);
                                }
                            }
                        }
                        break;
                    case 6:
                        if (nCH == 6)
                        {
                            lock (m_hNetworkServerAccessCriticalSection_a6)
                            {
                                if (m_nNetworkServerState_a[nCH] > 0x00000000)
                                {
                                    EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, pFrameBuffer, nFrameBufferLen);
                                }
                            }
                        }
                        break;
                    case 7:
                        if (nCH == 7)
                        {
                            lock (m_hNetworkServerAccessCriticalSection_a7)
                            {
                                if (m_nNetworkServerState_a[nCH] > 0x00000000)
                                {
                                    EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, pFrameBuffer, nFrameBufferLen);
                                }
                            }
                        }
                        break;
                    default:
                        break;
                }
            }

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // NO SIGNAL DETEACTED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_no_signal_detected(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            uint nCH = pUserData;

            OutputDebugString("CH" + (nCH + 1).ToString() + " No Signal Detected  \n");

            m_bNoSignal[nCH] = true;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // SIGNAL REMOVED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_signal_removed(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            uint nCH = pUserData;

            OutputDebugString("CH" + (nCH + 1).ToString() + " Signal Removed \n");

            m_bNoSignal[nCH] = true;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // CREATE CHANNEL WINDOW
            //
            for (i = 0; i < 8; i++)
            {
                m_pChannelControl_LIVE[i] = new MyChannelControl();

                m_pChannelControl_LIVE[i].Parent = this;

                // LEFT POSITION
                //
                if (i == 0 || i == 4) { m_pChannelControl_LIVE[i].Left = 0; }

                if (i == 1 || i == 5) { m_pChannelControl_LIVE[i].Left = ( this.Width / 4 ) * 1; }

                if (i == 2 || i == 6) { m_pChannelControl_LIVE[i].Left = ( this.Width / 4 ) * 2; }

                if (i == 3 || i == 7) { m_pChannelControl_LIVE[i].Left = ( this.Width / 4 ) * 3; }                

                // TOP POSITION
                //
                if (i == 0 || i == 1 || i == 2 || i == 3) { m_pChannelControl_LIVE[i].Top = 0; }

                if (i == 4 || i == 5 || i == 6 || i == 7) { m_pChannelControl_LIVE[i].Top = this.Height / 2; ; }                

                // WIDTH & HEIGHT
                //
                m_pChannelControl_LIVE[i].Size = new System.Drawing.Size(this.Width / 4, this.Height / 2);

                m_pChannelControl_LIVE[i].Visible = true;

                m_pChannelControl_LIVE[i].m_nChannelNumber = i + 1;

                m_bIsMaximizedChannelWindow[i] = false;

                m_nNetworkServerState_v[i] = 0x00000000;

                m_nNetworkServerState_a[i] = 0x00000000;
            }

            CloneChannelPanel1.Left = m_pChannelControl_LIVE[0].Left; CloneChannelPanel1.Top = m_pChannelControl_LIVE[0].Top; CloneChannelPanel1.Width = 160; CloneChannelPanel1.Height = 120; CloneChannelPanel1.Visible = false;

            CloneChannelPanel2.Left = m_pChannelControl_LIVE[1].Left; CloneChannelPanel2.Top = m_pChannelControl_LIVE[1].Top; CloneChannelPanel2.Width = 160; CloneChannelPanel2.Height = 120; CloneChannelPanel2.Visible = false;

            CloneChannelPanel3.Left = m_pChannelControl_LIVE[2].Left; CloneChannelPanel3.Top = m_pChannelControl_LIVE[2].Top; CloneChannelPanel3.Width = 160; CloneChannelPanel3.Height = 120; CloneChannelPanel3.Visible = false;

            CloneChannelPanel4.Left = m_pChannelControl_LIVE[3].Left; CloneChannelPanel4.Top = m_pChannelControl_LIVE[3].Top; CloneChannelPanel4.Width = 160; CloneChannelPanel4.Height = 120; CloneChannelPanel4.Visible = false;

            CloneChannelPanel5.Left = m_pChannelControl_LIVE[4].Left; CloneChannelPanel5.Top = m_pChannelControl_LIVE[4].Top; CloneChannelPanel5.Width = 160; CloneChannelPanel5.Height = 120; CloneChannelPanel5.Visible = false;

            CloneChannelPanel6.Left = m_pChannelControl_LIVE[5].Left; CloneChannelPanel6.Top = m_pChannelControl_LIVE[5].Top; CloneChannelPanel6.Width = 160; CloneChannelPanel6.Height = 120; CloneChannelPanel6.Visible = false;

            CloneChannelPanel7.Left = m_pChannelControl_LIVE[6].Left; CloneChannelPanel7.Top = m_pChannelControl_LIVE[6].Top; CloneChannelPanel7.Width = 160; CloneChannelPanel7.Height = 120; CloneChannelPanel7.Visible = false;

            CloneChannelPanel8.Left = m_pChannelControl_LIVE[7].Left; CloneChannelPanel8.Top = m_pChannelControl_LIVE[7].Top; CloneChannelPanel8.Width = 160; CloneChannelPanel8.Height = 120; CloneChannelPanel8.Visible = false;

            HwInitialize();

            // USER INTERFACE PROGRAMMING (SETUP CONTROL)
            //
            m_cSetupControl = new MySetupControl();

            m_cSetupControl.m_pMainForm = this;

            m_cSetupControl.FormClosed += new System.Windows.Forms.FormClosedEventHandler(this.SetupControlClosed);

            m_cSetupControl.Left = this.Left;

            m_cSetupControl.Top = this.Bottom - 20;

            m_cSetupControl.Visible = true;

            m_cSetupControl.Show();

            m_bShareRecordCH[0] = true; m_bShareRecordCH[1] = false; m_bShareRecordCH[2] = false; m_bShareRecordCH[3] = false;

            m_bShareRecordCH[4] = true; m_bShareRecordCH[5] = false; m_bShareRecordCH[6] = false; m_bShareRecordCH[7] = false;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            timerCheckSignal.Enabled = false;

            EXPORTS.QCAP_STOP_SHARE_RECORD(0);

            HwUnInitialize();

            //m_pinnedFrameArray.Free();
        }

        private void SetupControlClosed(object sender, FormClosedEventArgs e)
        {
            this.Close();
        }

        public void ShowCloneVideo(bool bShow)
        {
            if (bShow)
            {
                m_bShowClone = true;

                if (m_pChannelControl_LIVE[0].Visible == true)
                {                    
                    if (m_hCapDev[0] != 0)
                    {
                        EXPORTS.QCAP_CREATE_CLONE(m_hCapDev[0], (uint)CloneChannelPanel1.Handle.ToInt32(), ref m_hCloneCapDev[0], 1);

                        if (m_hCloneCapDev[0] != 0)
                        {
                            CloneChannelPanel1.Visible = true;

                            EXPORTS.QCAP_RUN(m_hCloneCapDev[0]);

                            EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCloneCapDev[0], 0);
                        }
                    }
                }

                if (m_pChannelControl_LIVE[1].Visible == true)
                {
                    if (m_hCapDev[1] != 0)
                    {
                        EXPORTS.QCAP_CREATE_CLONE(m_hCapDev[1], (uint)CloneChannelPanel2.Handle.ToInt32(), ref m_hCloneCapDev[1], 1);

                        if (m_hCloneCapDev[1] != 0)
                        {
                            CloneChannelPanel2.Visible = true;

                            EXPORTS.QCAP_RUN(m_hCloneCapDev[1]);

                            EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCloneCapDev[1], 0);
                        }
                    }
                }

                if (m_pChannelControl_LIVE[2].Visible == true)
                {
                    if (m_hCapDev[2] != 0)
                    {
                        EXPORTS.QCAP_CREATE_CLONE(m_hCapDev[2], (uint)CloneChannelPanel3.Handle.ToInt32(), ref m_hCloneCapDev[2], 1);

                        if (m_hCloneCapDev[2] != 0)
                        {
                            CloneChannelPanel3.Visible = true;

                            EXPORTS.QCAP_RUN(m_hCloneCapDev[2]);

                            EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCloneCapDev[2], 0);
                        }
                    }
                }

                if (m_pChannelControl_LIVE[3].Visible == true)
                {
                    if (m_hCapDev[3] != 0)
                    {
                        EXPORTS.QCAP_CREATE_CLONE(m_hCapDev[3], (uint)CloneChannelPanel4.Handle.ToInt32(), ref m_hCloneCapDev[3], 1);

                        if (m_hCloneCapDev[3] != 0)
                        {
                            CloneChannelPanel4.Visible = true;

                            EXPORTS.QCAP_RUN(m_hCloneCapDev[3]);

                            EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCloneCapDev[3], 0);
                        }
                    }
                }

                if (m_pChannelControl_LIVE[4].Visible == true)
                {
                    if (m_hCapDev[4] != 0)
                    {
                        EXPORTS.QCAP_CREATE_CLONE(m_hCapDev[4], (uint)CloneChannelPanel5.Handle.ToInt32(), ref m_hCloneCapDev[4], 1);

                        if (m_hCloneCapDev[4] != 0)
                        {
                            CloneChannelPanel5.Visible = true;

                            EXPORTS.QCAP_RUN(m_hCloneCapDev[4]);

                            EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCloneCapDev[4], 0);
                        }
                    }
                }

                if (m_pChannelControl_LIVE[5].Visible == true)
                {
                    if (m_hCapDev[5] != 0)
                    {
                        EXPORTS.QCAP_CREATE_CLONE(m_hCapDev[5], (uint)CloneChannelPanel6.Handle.ToInt32(), ref m_hCloneCapDev[5], 1);

                        if (m_hCloneCapDev[5] != 0)
                        {
                            CloneChannelPanel6.Visible = true;

                            EXPORTS.QCAP_RUN(m_hCloneCapDev[5]);

                            EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCloneCapDev[5], 0);
                        }
                    }
                }

                if (m_pChannelControl_LIVE[6].Visible == true)
                {
                    if (m_hCapDev[6] != 0)
                    {
                        EXPORTS.QCAP_CREATE_CLONE(m_hCapDev[6], (uint)CloneChannelPanel7.Handle.ToInt32(), ref m_hCloneCapDev[6], 1);

                        if (m_hCloneCapDev[6] != 0)
                        {
                            CloneChannelPanel7.Visible = true;

                            EXPORTS.QCAP_RUN(m_hCloneCapDev[6]);

                            EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCloneCapDev[6], 0);
                        }
                    }
                }

                if (m_pChannelControl_LIVE[7].Visible == true)
                {
                    if (m_hCapDev[7] != 0)
                    {
                        EXPORTS.QCAP_CREATE_CLONE(m_hCapDev[7], (uint)CloneChannelPanel8.Handle.ToInt32(), ref m_hCloneCapDev[7], 1);

                        if (m_hCloneCapDev[7] != 0)
                        {
                            CloneChannelPanel8.Visible = true;

                            EXPORTS.QCAP_RUN(m_hCloneCapDev[7]);

                            EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCloneCapDev[7], 0);
                        }
                    }
                }               

            }
            else
            {
                m_bShowClone = false;

                if (m_pChannelControl_LIVE[0].Visible == true)
                {
                    CloneChannelPanel1.Visible = false;

                    if (m_hCloneCapDev[0] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[0]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[0]); m_hCloneCapDev[0] = 0; }
                }

                if (m_pChannelControl_LIVE[1].Visible == true)
                {
                    CloneChannelPanel2.Visible = false;

                    if (m_hCloneCapDev[1] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[1]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[1]); m_hCloneCapDev[1] = 0; }
                }

                if (m_pChannelControl_LIVE[2].Visible == true)
                {
                    CloneChannelPanel3.Visible = false;

                    if (m_hCloneCapDev[2] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[2]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[2]); m_hCloneCapDev[2] = 0; }
                }

                if (m_pChannelControl_LIVE[3].Visible == true)
                {
                    CloneChannelPanel4.Visible = false;

                    if (m_hCloneCapDev[3] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[3]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[3]); m_hCloneCapDev[3] = 0; }
                }

                if (m_pChannelControl_LIVE[4].Visible == true)
                {
                    CloneChannelPanel5.Visible = false;

                    if (m_hCloneCapDev[4] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[4]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[4]); m_hCloneCapDev[4] = 0; }
                }

                if (m_pChannelControl_LIVE[5].Visible == true)
                {
                    CloneChannelPanel6.Visible = false;

                    if (m_hCloneCapDev[5] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[5]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[5]); m_hCloneCapDev[5] = 0; }
                }

                if (m_pChannelControl_LIVE[6].Visible == true)
                {
                    CloneChannelPanel7.Visible = false;

                    if (m_hCloneCapDev[6] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[6]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[6]); m_hCloneCapDev[6] = 0; }
                }

                if (m_pChannelControl_LIVE[7].Visible == true)
                {
                    CloneChannelPanel8.Visible = false;

                    if (m_hCloneCapDev[7] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[7]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[7]); m_hCloneCapDev[7] = 0; }
                }
            }
        }

        public void OnLButtonDown_ChannelControl(uint nChannelNumber)
        {
            if (m_bIsMaximizedChannelWindow[nChannelNumber - 1])
            {
                m_bIsMaximizedChannelWindow[nChannelNumber - 1] = false;

                for (i = 0; i < 8; i++)
                {
                    // LEFT POSITION
                    //
                    if (i == 0 || i == 4) { m_pChannelControl_LIVE[i].Left = 0; }

                    if (i == 1 || i == 5) { m_pChannelControl_LIVE[i].Left = (this.Width / 4) * 1; }

                    if (i == 2 || i == 6) { m_pChannelControl_LIVE[i].Left = (this.Width / 4) * 2; }

                    if (i == 3 || i == 7) { m_pChannelControl_LIVE[i].Left = (this.Width / 4) * 3; }

                    // TOP POSITION
                    //
                    if (i == 0 || i == 1 || i == 2 || i == 3) { m_pChannelControl_LIVE[i].Top = 0; }

                    if (i == 4 || i == 5 || i == 6 || i == 7) { m_pChannelControl_LIVE[i].Top = this.Height / 2; ; }

                    m_pChannelControl_LIVE[i].Size = new System.Drawing.Size(this.Width / 4, this.Height / 2);

                    m_pChannelControl_LIVE[i].Visible = true;
                }                
            }
            else
            {
                m_bIsMaximizedChannelWindow[nChannelNumber - 1] = true;

                for (i = 0; i < 8; i++) { m_pChannelControl_LIVE[i].Visible = false; }

                CloneChannelPanel1.Visible = false; CloneChannelPanel2.Visible = false; CloneChannelPanel3.Visible = false; CloneChannelPanel4.Visible = false;

                CloneChannelPanel5.Visible = false; CloneChannelPanel6.Visible = false; CloneChannelPanel7.Visible = false; CloneChannelPanel8.Visible = false;

                m_pChannelControl_LIVE[nChannelNumber - 1].Left = 0;

                m_pChannelControl_LIVE[nChannelNumber - 1].Top = 0;

                m_pChannelControl_LIVE[nChannelNumber - 1].Size = new System.Drawing.Size(this.Width, this.Height);

                m_pChannelControl_LIVE[nChannelNumber - 1].Visible = true;                
            }            

            CloneChannelPanel1.Left = m_pChannelControl_LIVE[0].Left; CloneChannelPanel1.Top = m_pChannelControl_LIVE[0].Top; CloneChannelPanel1.Width = 160; CloneChannelPanel1.Height = 120;

            CloneChannelPanel2.Left = m_pChannelControl_LIVE[1].Left; CloneChannelPanel2.Top = m_pChannelControl_LIVE[1].Top; CloneChannelPanel2.Width = 160; CloneChannelPanel2.Height = 120;

            CloneChannelPanel3.Left = m_pChannelControl_LIVE[2].Left; CloneChannelPanel3.Top = m_pChannelControl_LIVE[2].Top; CloneChannelPanel3.Width = 160; CloneChannelPanel3.Height = 120;

            CloneChannelPanel4.Left = m_pChannelControl_LIVE[3].Left; CloneChannelPanel4.Top = m_pChannelControl_LIVE[3].Top; CloneChannelPanel4.Width = 160; CloneChannelPanel4.Height = 120;

            CloneChannelPanel5.Left = m_pChannelControl_LIVE[4].Left; CloneChannelPanel5.Top = m_pChannelControl_LIVE[4].Top; CloneChannelPanel5.Width = 160; CloneChannelPanel5.Height = 120;

            CloneChannelPanel6.Left = m_pChannelControl_LIVE[5].Left; CloneChannelPanel6.Top = m_pChannelControl_LIVE[5].Top; CloneChannelPanel6.Width = 160; CloneChannelPanel6.Height = 120;

            CloneChannelPanel7.Left = m_pChannelControl_LIVE[6].Left; CloneChannelPanel7.Top = m_pChannelControl_LIVE[6].Top; CloneChannelPanel7.Width = 160; CloneChannelPanel7.Height = 120;

            CloneChannelPanel8.Left = m_pChannelControl_LIVE[7].Left; CloneChannelPanel8.Top = m_pChannelControl_LIVE[7].Top; CloneChannelPanel8.Width = 160; CloneChannelPanel8.Height = 120;

            if (m_hCloneCapDev[0] != 0 && m_bShowClone) { CloneChannelPanel1.Visible = true; }

            if (m_hCloneCapDev[1] != 0 && m_bShowClone) { CloneChannelPanel2.Visible = true; }

            if (m_hCloneCapDev[2] != 0 && m_bShowClone) { CloneChannelPanel3.Visible = true; }

            if (m_hCloneCapDev[3] != 0 && m_bShowClone) { CloneChannelPanel4.Visible = true; }

            if (m_hCloneCapDev[4] != 0 && m_bShowClone) { CloneChannelPanel5.Visible = true; }

            if (m_hCloneCapDev[5] != 0 && m_bShowClone) { CloneChannelPanel6.Visible = true; }

            if (m_hCloneCapDev[6] != 0 && m_bShowClone) { CloneChannelPanel7.Visible = true; }

            if (m_hCloneCapDev[7] != 0 && m_bShowClone) { CloneChannelPanel8.Visible = true; }
        }

        public void OnRButtonDown_ChannelControl(uint nChannelNumber)
        {
            // CHANGE CHANNEL WINDOWS SIZE AND POSITION
            //
            if (!m_bIsMaximizedForm)
            {
                this.WindowState = FormWindowState.Maximized;

                m_bIsMaximizedForm = true;
            }
            else
            {
                this.WindowState = FormWindowState.Normal;

                m_bIsMaximizedForm = false;
            }

            if (m_bIsMaximizedChannelWindow[nChannelNumber - 1])
            {
                m_pChannelControl_LIVE[nChannelNumber - 1].Left = 0;

                m_pChannelControl_LIVE[nChannelNumber - 1].Top = 0;

                m_pChannelControl_LIVE[nChannelNumber - 1].Size = new System.Drawing.Size(this.Width, this.Height);

                m_pChannelControl_LIVE[nChannelNumber - 1].Visible = true;                
            }
            else
            {
                for (i = 0; i < 8; i++)
                {
                    // LEFT POSITION
                    //
                    if (i == 0 || i == 4) { m_pChannelControl_LIVE[i].Left = 0; }

                    if (i == 1 || i == 5) { m_pChannelControl_LIVE[i].Left = (this.Width / 4) * 1; }

                    if (i == 2 || i == 6) { m_pChannelControl_LIVE[i].Left = (this.Width / 4) * 2; }

                    if (i == 3 || i == 7) { m_pChannelControl_LIVE[i].Left = (this.Width / 4) * 3; }

                    // TOP POSITION
                    //
                    if (i == 0 || i == 1 || i == 2 || i == 3) { m_pChannelControl_LIVE[i].Top = 0; }

                    if (i == 4 || i == 5 || i == 6 || i == 7) { m_pChannelControl_LIVE[i].Top = this.Height / 2; ; }

                    m_pChannelControl_LIVE[i].Size = new System.Drawing.Size(this.Width / 4, this.Height / 2);

                    m_pChannelControl_LIVE[i].Visible = true;
                }                                      
            }

            CloneChannelPanel1.Left = m_pChannelControl_LIVE[0].Left; CloneChannelPanel1.Top = m_pChannelControl_LIVE[0].Top; CloneChannelPanel1.Width = 160; CloneChannelPanel1.Height = 120;

            CloneChannelPanel2.Left = m_pChannelControl_LIVE[1].Left; CloneChannelPanel2.Top = m_pChannelControl_LIVE[1].Top; CloneChannelPanel2.Width = 160; CloneChannelPanel2.Height = 120;

            CloneChannelPanel3.Left = m_pChannelControl_LIVE[2].Left; CloneChannelPanel3.Top = m_pChannelControl_LIVE[2].Top; CloneChannelPanel3.Width = 160; CloneChannelPanel3.Height = 120;

            CloneChannelPanel4.Left = m_pChannelControl_LIVE[3].Left; CloneChannelPanel4.Top = m_pChannelControl_LIVE[3].Top; CloneChannelPanel4.Width = 160; CloneChannelPanel4.Height = 120;

            CloneChannelPanel5.Left = m_pChannelControl_LIVE[4].Left; CloneChannelPanel5.Top = m_pChannelControl_LIVE[4].Top; CloneChannelPanel5.Width = 160; CloneChannelPanel5.Height = 120;

            CloneChannelPanel6.Left = m_pChannelControl_LIVE[5].Left; CloneChannelPanel6.Top = m_pChannelControl_LIVE[5].Top; CloneChannelPanel6.Width = 160; CloneChannelPanel6.Height = 120;

            CloneChannelPanel7.Left = m_pChannelControl_LIVE[6].Left; CloneChannelPanel7.Top = m_pChannelControl_LIVE[6].Top; CloneChannelPanel7.Width = 160; CloneChannelPanel7.Height = 120;

            CloneChannelPanel8.Left = m_pChannelControl_LIVE[7].Left; CloneChannelPanel8.Top = m_pChannelControl_LIVE[7].Top; CloneChannelPanel8.Width = 160; CloneChannelPanel8.Height = 120;

            if (m_hCloneCapDev[0] != 0 && m_bShowClone) { CloneChannelPanel1.Visible = true; }

            if (m_hCloneCapDev[1] != 0 && m_bShowClone) { CloneChannelPanel2.Visible = true; }

            if (m_hCloneCapDev[2] != 0 && m_bShowClone) { CloneChannelPanel3.Visible = true; }

            if (m_hCloneCapDev[3] != 0 && m_bShowClone) { CloneChannelPanel4.Visible = true; }

            if (m_hCloneCapDev[4] != 0 && m_bShowClone) { CloneChannelPanel5.Visible = true; }

            if (m_hCloneCapDev[5] != 0 && m_bShowClone) { CloneChannelPanel6.Visible = true; }

            if (m_hCloneCapDev[6] != 0 && m_bShowClone) { CloneChannelPanel7.Visible = true; }

            if (m_hCloneCapDev[7] != 0 && m_bShowClone) { CloneChannelPanel8.Visible = true; }
        }

        public bool HwInitialize()
        {
            for (i = 0; i < 8; i++) { m_hCapDev[i] = 0x00000000; }

            for (i = 0; i < 8; i++) { m_hCloneCapDev[i] = 0x00000000; }

            for (i = 0; i < 8; i++) { m_bNoSignal[i] = true; }

            for (i = 0; i < 8; i++) { m_strFormatChangedOutput[i] = ""; }

            // CREATE CAPTURE DEVICE            
            //
            for (i = 0; i < 8; i++)
            {
                string str_chip_name = m_strChipName;

                EXPORTS.QCAP_CREATE(ref str_chip_name, i, (uint)m_pChannelControl_LIVE[i].Handle.ToInt32(), ref m_hCapDev[i], 1);
            }

            // REGISTER FORMAT CHANGED CALLBACK FUNCTION
            // 
            m_pFormatChangedCB = new EXPORTS.PF_FORMAT_CHANGED_CALLBACK(on_process_format_changed);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[0], m_pFormatChangedCB, 0);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[1], m_pFormatChangedCB, 1);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[2], m_pFormatChangedCB, 2);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[3], m_pFormatChangedCB, 3);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[4], m_pFormatChangedCB, 4);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[5], m_pFormatChangedCB, 5);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[6], m_pFormatChangedCB, 6);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[7], m_pFormatChangedCB, 7);

            // REGISTER PREVIEW VIDEO CALLBACK FUNCTION
            // 
            m_pPreviewVideoCB = new EXPORTS.PF_VIDEO_PREVIEW_CALLBACK(on_process_preview_video_buffer);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[0], m_pPreviewVideoCB, 0);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[1], m_pPreviewVideoCB, 1);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[2], m_pPreviewVideoCB, 2);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[3], m_pPreviewVideoCB, 3);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[4], m_pPreviewVideoCB, 4);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[5], m_pPreviewVideoCB, 5);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[6], m_pPreviewVideoCB, 6);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[7], m_pPreviewVideoCB, 7);

            // REGISTER PREVIEW AUDIO CALLBACK FUNCTION
            //
            m_pPreviewAudioCB = new EXPORTS.PF_AUDIO_PREVIEW_CALLBACK(on_process_preview_audio_buffer);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[0], m_pPreviewAudioCB, 0);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[1], m_pPreviewAudioCB, 1);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[2], m_pPreviewAudioCB, 2);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[3], m_pPreviewAudioCB, 3);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[4], m_pPreviewAudioCB, 4);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[5], m_pPreviewAudioCB, 5);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[6], m_pPreviewAudioCB, 6);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[7], m_pPreviewAudioCB, 7);

            // REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
            //
            m_pNoSignalDetectedCB = new EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK(on_process_no_signal_detected);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[0], m_pNoSignalDetectedCB, 0);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[1], m_pNoSignalDetectedCB, 1);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[2], m_pNoSignalDetectedCB, 2);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[3], m_pNoSignalDetectedCB, 3);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[4], m_pNoSignalDetectedCB, 4);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[5], m_pNoSignalDetectedCB, 5);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[6], m_pNoSignalDetectedCB, 6);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[7], m_pNoSignalDetectedCB, 7);

            // REGISTER SIGNAL REMOVED CALLBACK FUNCTION
            //
            m_pSignalRemovedCB = new EXPORTS.PF_SIGNAL_REMOVED_CALLBACK(on_process_signal_removed);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[0], m_pSignalRemovedCB, 0);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[1], m_pSignalRemovedCB, 1);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[2], m_pSignalRemovedCB, 2);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[3], m_pSignalRemovedCB, 3);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[4], m_pSignalRemovedCB, 4);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[5], m_pSignalRemovedCB, 5);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[6], m_pSignalRemovedCB, 6);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[7], m_pSignalRemovedCB, 7);

            // SET INPUT
            //
            uint nInput = (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SDI;

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[0], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[1], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[2], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[3], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[4], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[5], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[6], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[7], nInput);

            // RUN DEVICE
            //
            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[0], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[1], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[2], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[3], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[4], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[5], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[6], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[7], 0);

            EXPORTS.QCAP_RUN(m_hCapDev[0]);

            EXPORTS.QCAP_RUN(m_hCapDev[1]);

            EXPORTS.QCAP_RUN(m_hCapDev[2]);

            EXPORTS.QCAP_RUN(m_hCapDev[3]);

            EXPORTS.QCAP_RUN(m_hCapDev[4]);

            EXPORTS.QCAP_RUN(m_hCapDev[5]);

            EXPORTS.QCAP_RUN(m_hCapDev[6]);

            EXPORTS.QCAP_RUN(m_hCapDev[7]);

            timerCheckSignal.Enabled = true;

            return true;
        }

        public bool HwUnInitialize()
        {
            EXPORTS.QCAP_DESTROY_BROADCAST_SERVER(m_hRtspCapDev);

            if (m_hCloneCapDev[0] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[0]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[0]); }

            if (m_hCloneCapDev[1] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[1]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[1]); }

            if (m_hCloneCapDev[2] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[2]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[2]); }

            if (m_hCloneCapDev[3] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[3]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[3]); }

            if (m_hCloneCapDev[4] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[4]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[4]); }

            if (m_hCloneCapDev[5] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[5]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[5]); }

            if (m_hCloneCapDev[6] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[6]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[6]); }

            if (m_hCloneCapDev[7] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[7]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[7]); }

            if (m_hCapDev[0] != 0) { EXPORTS.QCAP_STOP(m_hCapDev[0]); EXPORTS.QCAP_DESTROY(m_hCapDev[0]); }

            if (m_hCapDev[1] != 0) { EXPORTS.QCAP_STOP(m_hCapDev[1]); EXPORTS.QCAP_DESTROY(m_hCapDev[1]); }

            if (m_hCapDev[2] != 0) { EXPORTS.QCAP_STOP(m_hCapDev[2]); EXPORTS.QCAP_DESTROY(m_hCapDev[2]); }

            if (m_hCapDev[3] != 0) { EXPORTS.QCAP_STOP(m_hCapDev[3]); EXPORTS.QCAP_DESTROY(m_hCapDev[3]); }

            if (m_hCapDev[4] != 0) { EXPORTS.QCAP_STOP(m_hCapDev[4]); EXPORTS.QCAP_DESTROY(m_hCapDev[4]); }

            if (m_hCapDev[5] != 0) { EXPORTS.QCAP_STOP(m_hCapDev[5]); EXPORTS.QCAP_DESTROY(m_hCapDev[5]); }

            if (m_hCapDev[6] != 0) { EXPORTS.QCAP_STOP(m_hCapDev[6]); EXPORTS.QCAP_DESTROY(m_hCapDev[6]); }

            if (m_hCapDev[7] != 0) { EXPORTS.QCAP_STOP(m_hCapDev[7]); EXPORTS.QCAP_DESTROY(m_hCapDev[7]); }

            return true;
        }

        private void timerCheckSignal_Tick(object sender, EventArgs e)
        {
            // DISPLAY FORMAT CHANGED MESSAGE
            //
            if (m_bNoSignal[0]) { m_cSetupControl.m_strFormatChangedOutput1 = " INFO :  . . ."; } else { m_cSetupControl.m_strFormatChangedOutput1 = m_strFormatChangedOutput[0]; }

            if (m_bNoSignal[1]) { m_cSetupControl.m_strFormatChangedOutput2 = " INFO :  . . ."; } else { m_cSetupControl.m_strFormatChangedOutput2 = m_strFormatChangedOutput[1]; }

            if (m_bNoSignal[2]) { m_cSetupControl.m_strFormatChangedOutput3 = " INFO :  . . ."; } else { m_cSetupControl.m_strFormatChangedOutput3 = m_strFormatChangedOutput[2]; }

            if (m_bNoSignal[3]) { m_cSetupControl.m_strFormatChangedOutput4 = " INFO :  . . ."; } else { m_cSetupControl.m_strFormatChangedOutput4 = m_strFormatChangedOutput[3]; }

            if (m_bNoSignal[4]) { m_cSetupControl.m_strFormatChangedOutput4 = " INFO :  . . ."; } else { m_cSetupControl.m_strFormatChangedOutput5 = m_strFormatChangedOutput[4]; }

            if (m_bNoSignal[5]) { m_cSetupControl.m_strFormatChangedOutput4 = " INFO :  . . ."; } else { m_cSetupControl.m_strFormatChangedOutput6 = m_strFormatChangedOutput[5]; }

            if (m_bNoSignal[6]) { m_cSetupControl.m_strFormatChangedOutput4 = " INFO :  . . ."; } else { m_cSetupControl.m_strFormatChangedOutput7 = m_strFormatChangedOutput[6]; }

            if (m_bNoSignal[7]) { m_cSetupControl.m_strFormatChangedOutput4 = " INFO :  . . ."; } else { m_cSetupControl.m_strFormatChangedOutput8 = m_strFormatChangedOutput[7]; }

            m_cSetupControl.m_bNoSignal1 = m_bNoSignal[0];

            m_cSetupControl.m_bNoSignal2 = m_bNoSignal[1];

            m_cSetupControl.m_bNoSignal3 = m_bNoSignal[2];

            m_cSetupControl.m_bNoSignal4 = m_bNoSignal[3];

            m_cSetupControl.m_bNoSignal5 = m_bNoSignal[4];

            m_cSetupControl.m_bNoSignal6 = m_bNoSignal[5];

            m_cSetupControl.m_bNoSignal7 = m_bNoSignal[6];

            m_cSetupControl.m_bNoSignal8 = m_bNoSignal[7];
        }
    }
}
